import refreshTokenHelper from "../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.orderLineId) {
    newObjValue = {...newObjValue, 
      C_OrderLine_ID: {
        id: body.orderLineId,
        tableName: 'C_OrderLine'
      }
    }
  }
  if(body.uomId) {
    newObjValue = {...newObjValue, 
      C_UOM_ID: {
        id: body.uomId,
        tableName: 'C_UOM'
      }
    }
  }
  if(body.inOutLineId) {
    newObjValue = {...newObjValue, 
      M_InOutLine_ID: {
        id: body.inOutLineId,
        tableName: 'M_InOutLine'
      }
    }
  }
  if(body.taxId) {
    newObjValue = {...newObjValue, 
      C_Tax_ID: {
        id: body.taxId,
        tableName: 'C_Tax'
      }
    }
  }
  if(body.attributeSetInstanceId) {
    newObjValue = {...newObjValue, 
      M_AttributeSetInstance_ID: {
        id: body.attributeSetInstanceId,
        tableName: 'M_AttributeSetInstance'
      }
    }
  }
  if(body.chargeId) {
    newObjValue = {...newObjValue, 
      C_Charge_ID: {
        id: body.chargeId,
        tableName: 'C_Charge'
      }
    }
  }
  if(body.projectId) {
    newObjValue = {...newObjValue, 
      C_Project_ID: {
        id: body.projectId,
        tableName: 'C_Project'
      }
    }
  }
  if(body.campaignId) {
    newObjValue = {...newObjValue, 
      C_Campaign_ID: {
        id: body.campaignId,
        tableName: 'C_Campaign'
      }
    }
  }

  if(body.invoiceId && body.productId) {
    const res: any = await fetchHelper(event, 'models/c_invoiceline', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      isActive: body.isActive,
      line: body.line,
      /*qtyInvoiced: body.qtyInvoiced,
      taxAmt: body.taxAmt,
      A_CreateAsset: body.A_CreateAsset,
      A_Processed: body.A_Processed,*/
      isPrinted: body.isPrinted,
      qtyEntered: body.qtyEntered,
      priceList: body.priceList,
      priceActual: body.priceActual,
      priceLimit: body.priceLimit,
      priceEntered: body.priceEntered,
      isDescription: body.isDescription,
      description: body.description,
      processed: body.processed,
      C_Invoice_ID: {
        id: body.invoiceId,
        tableName: 'C_Invoice'
      },
      M_Product_ID: {
        id: body.productId,
        tableName: 'M_Product'
      },
      ...newObjValue,
      tableName: 'C_Invoiceline'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})